package net.minecraft.src;
import net.minecraft.client.Minecraft;
import java.io.File;

public class TileEntityBlockColored extends TileEntity
{

	public TileEntityBlockColored()
	{
		oBlockId = 3;
		lightvalue = 0;
		redValue = 0x00;
		greenValue = 0xff;
		blueValue = 0x00;
	}

	public void updateEntity()
	{
		super.updateEntity();
	}

	public void setBlock(int d, IBlockAccess world, int i, int j, int k, int meta)
	{
		oBlockId = d;
		if(Block.blocksList[oBlockId] != null)
		{
			lightvalue = Block.blocksList[oBlockId].getLightValue(world, i, j, k);
		}
	}

	public void setRed(int i)
	{
		redValue = i;
	}

	public void setGreen(int i)
	{
		greenValue = i;
	}

	public void setBlue(int i)
	{
		blueValue = i;	
	}


	public int getRGB()
	{
		return ((redValue << 16) | (greenValue << 8)) | (blueValue);
	}

	public void readFromNBT(NBTTagCompound nbttagcompound)
	{
		super.readFromNBT(nbttagcompound);
		oBlockId = nbttagcompound.getInteger("blockid");
		lightvalue = nbttagcompound.getInteger("lightvalue");
		redValue = nbttagcompound.getInteger("redValue");
		greenValue = nbttagcompound.getInteger("greenValue");
		blueValue = nbttagcompound.getInteger("blueValue");
	}
	
	public void writeToNBT(NBTTagCompound nbttagcompound)
	{
        super.writeToNBT(nbttagcompound);
		nbttagcompound.setInteger("blockid", (oBlockId));
		nbttagcompound.setInteger("lightvalue", (lightvalue));
		nbttagcompound.setInteger("redValue", (redValue));
		nbttagcompound.setInteger("greenValue", (greenValue));
		nbttagcompound.setInteger("blueValue", (blueValue));
	}

	public int oBlockId;
	public int lightvalue;
	public int redValue;
	public int greenValue;
	public int blueValue;
}